function res = chris_osc_jitter
% This is a new function to calculate jitter. 

% May 19 2014: Created.
% May 20 2014: Moving towards jitter calculation itself.
% May 21 2014: Fixing jitter calculations for some weird non-spiky cells.
% Jan 17 2015: Now supports making a jitter pic for one cell only (make LIST non-empty).

res =[];

rasterFigure = 1;               % In case a global raster-figure is needed
dynamicFigure = 1;              % In case you also want to make this figure (above) dynamic (it slows the script quite a bit, mind it)
useSticks = 1;                  % Set to one if on a raster figure you need sticks instead of dots (when using 1 or few cells)

list = 22003;                   % Make non-empty if need to restrict the set of cells to process

fid = fopen('C:\Users\Arseny\Documents\4_Cells Classification\2014 data\chris_oscillations_dat.txt','r');
temp = fgetl(fid);              % Read first row to get rid of the headers
a = fscanf(fid,'%f');
fclose(fid);
                                %                                          1        2            3       4       5
a = reshape(a,5,[])';           % Now cells run down, and the columns are: cell_id, bumps group, Amp mV, Lat ms, Sweep#
a(a(:,4)<0,:) = [];             % Remove negative latencies.

nRows = size(a,1);
if(~exist('list','var')); list = []; end;   % To simplify comparisons later on
traceLength = 2500;             % Bout length in 1/10 of a ms (actual number was closer to 200 ms, but it's safer to keep it slightly larger)
xGap = 420;                     % Gap between traces from different bump groups
myColor = 'kgbrcmkgbrcmkgbrcm'; % Different colors for different trace groups

id = 0;         % Current cell id
iCell = 0;      % Current cell number
iRow = 0;       % Current row
trace = zeros(traceLength*5,10);    % Here traces will be stored
if(rasterFigure|dynamicFigure)
    figure('Color','w'); hold on;
end

while(iRow<nRows)
    iRow = iRow+1;      % New row
    if(id~=a(iRow,1))   % If new cell has just started
        if(iCell>0)                                                     % Not the first cell ever
            if(isempty(list) || ismember(id,list))                      % Either no restriction set, or the cell is in the set
                jitter(iCell) = processCell(iCell,id,trace);            % Data for previous cell is collected. Process it.
            end
        end
        id = a(iRow,1);                                                 % Previous cell id
        iCell = iCell+1;        
        trace = zeros(traceLength*5,10);                                % Blank the traces
        if(dynamicFigure)
            if(mod(iCell,10)==0)
                drawnow;                                                % Even in dynamic mode draw only rarely, to save the speed
            end
        end
    end
    if(isempty(list) || ismember(a(iRow,1),list))
        if(rasterFigure|dynamicFigure)                                  % If you need a figure, you draw it, but you only DRAWNOW if you want it dynamic
            if(~useSticks)
                plot(a(iRow,5)+iCell*10 , a(iRow,4)+traceLength*(a(iRow,2)-1),'.','MarkerSize',1);    
            else
                %                  1        2            3       4       5
                % The columns are: cell_id, bumps group, Amp mV, Lat ms, Sweep#
                plot((a(iRow,4)+xGap*(a(iRow,2)-1))*[1 1], a(iRow,5)+iCell + [-1 1]*0.4,'-','Color',myColor(a(iRow,2)));    
            end
        end    
    end
    trace(round(a(iRow,4)*10)+traceLength*a(iRow,2),a(iRow,5)) = 1;     % Put a spike on the trace    
end
if(isempty(list) || ismember(id,list)) 
    jitter(iCell) = processCell(iCell,id,trace);                        % Process last cell data
end
if(rasterFigure|dynamicFigure)
    hold off;
end

%res = jitter;

end


function jitter = processCell(iCell,id,trace)
% Calculates the jitter from [0 1] traces.

fprintf('%3d\t%7d\t',iCell,id);                             % Announce this cell

precision = 10;             % Dots per ms
gWidth = 2;                 % Sigma, in ms
gaussian = exp(-(-gWidth*3*precision:gWidth*3*precision).^2/(gWidth*precision)^2);  % 3 sigma gaussian

nSpikes = sum(trace);       % How many spikes are there in each sweep
trace = trace(:,nSpikes>0); % We only leave traces with spikes
nSweeps = size(trace,2);
if(nSweeps==0)
    jitter = NaN;
    return;
end

blurred = zeros(size(trace));
for(iSweep=1:nSweeps)
    blurred(:,iSweep) = conv(trace(:,iSweep),gaussian,'same');    % Blur
end

norms = sqrt(sum(blurred.^2));
icount = 0;
for(is1=2:nSweeps)          % For each pair of sweeps
    for(is2=1:(is1-1))
        icount = icount+1;
        crossCorr(icount) = blurred(:,is1)'*blurred(:,is2)/(norms(is1)*norms(is2));
    end
end

jitter = mean(crossCorr);

fprintf('%6.4f\n',jitter);                                          % Close the reporting row
end